/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.platform;

import dev.latvian.mods.kubejs.item.InventoryJS;
import dev.latvian.mods.kubejs.item.ItemHandler;
import dev.latvian.mods.kubejs.level.LevelPlatformHelper;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.filter.biome.forge.BiomeDictionaryFilter;
import dev.latvian.mods.kubejs.level.gen.forge.BiomeDictionaryWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class LevelPlatformHelperImpl
implements LevelPlatformHelper {
    @Override
    public InventoryJS getInventoryFromBlockEntity(BlockEntity tileEntity, Direction facing) {
        final IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null);
        if (handler != null) {
            if (handler instanceof IItemHandlerModifiable) {
                final IItemHandlerModifiable modifiableHandler = (IItemHandlerModifiable)handler;
                return new InventoryJS(new ItemHandler.Mutable(){

                    @Override
                    public void setStackInSlot(int i, @Nonnull ItemStack itemStack) {
                        modifiableHandler.setStackInSlot(i, itemStack);
                    }

                    @Override
                    public int getSlots() {
                        return handler.getSlots();
                    }

                    @Override
                    public ItemStack getStackInSlot(int i) {
                        return handler.getStackInSlot(i);
                    }

                    @Override
                    public ItemStack insertItem(int i, ItemStack itemStack, boolean b) {
                        return handler.insertItem(i, itemStack, b);
                    }

                    @Override
                    public ItemStack extractItem(int i, int i1, boolean b) {
                        return handler.extractItem(i, i1, b);
                    }

                    @Override
                    public int getSlotLimit(int i) {
                        return handler.getSlotLimit(i);
                    }

                    @Override
                    public boolean isItemValid(int i, ItemStack itemStack) {
                        return handler.isItemValid(i, itemStack);
                    }
                });
            }
            return new InventoryJS(new ItemHandler(){

                @Override
                public int getSlots() {
                    return handler.getSlots();
                }

                @Override
                public ItemStack getStackInSlot(int i) {
                    return handler.getStackInSlot(i);
                }

                @Override
                public ItemStack insertItem(int i, ItemStack itemStack, boolean b) {
                    return handler.insertItem(i, itemStack, b);
                }

                @Override
                public ItemStack extractItem(int i, int i1, boolean b) {
                    return handler.extractItem(i, i1, b);
                }

                @Override
                public int getSlotLimit(int i) {
                    return handler.getSlotLimit(i);
                }

                @Override
                public boolean isItemValid(int i, ItemStack itemStack) {
                    return handler.isItemValid(i, itemStack);
                }
            });
        }
        return null;
    }

    @Override
    public BiomeFilter ofStringAdditional(String s) {
        return switch (s.charAt(0)) {
            case '#' -> {
                ConsoleJS.STARTUP.error("Biome Tag filters are currently not supported on Forge!");
                yield null;
            }
            case '$' -> new BiomeDictionaryFilter(BiomeDictionaryWrapper.getBiomeType(s.substring(1)));
            default -> null;
        };
    }

    @Override
    public BiomeFilter ofMapAdditional(Map<String, Object> map) {
        if (map.containsKey("biome_type")) {
            BiomeDictionary.Type type = BiomeDictionaryWrapper.getBiomeType(map.get("biome_type"));
            return new BiomeDictionaryFilter(type);
        }
        return null;
    }

    @Override
    public boolean areCapsCompatible(ItemStack a, ItemStack b) {
        return a.areCapsCompatible((CapabilityProvider)b);
    }

    @Override
    public double getReachDistance(LivingEntity livingEntity) {
        return livingEntity.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
    }
}

